% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSettingKeys.R
\name{getSettingKeys}
\alias{getSettingKeys}
\title{Get setting keys matching a pattern}
\usage{
getSettingKeys(patterns, settings, parents = NULL, matchLists = FALSE)
}
\arguments{
\item{patterns}{List  of text patterns to match with named elements in \code{settings}.}

\item{settings}{List of settings used to generate a chart like \code{eDISH()}.}

\item{parents}{List containing the position of the parent list using recursive matches.}

\item{matchLists}{Boolean indicating whether keys containing lists should be returned as matches.}
}
\value{
List of lists specifying the position of matching named elements in the format \code{list("filters",2,"value_col")}, which would correspond to \code{settings[["filters"]][[2]][["value_col"]]}.
}
\description{
Recursive function to find all keys matching a given text pattern in a settings list
}
\details{
This function loops through all named elements (or "keys") in a \code{settings} list and returns items that match \code{patterns}. If \code{matchLists==FALSE} (the default), the function iteratively looks through the named elements in nested lists using the built-in \code{parents} parameter. The function returns a array of keys for all matches using a list of lists. Each key is defines the position of a matching key using an unnamed list. For example, \code{list("filters",2,"value_col")} would correspond to \code{settings[["filters"]][[2]][["value_col"]]}.
}
\examples{
testSettings<-generateSettings(standard="AdAM")

# returns list of all matching values
safetyGraphics:::getSettingKeys(patterns=c("_col"),
                                settings=testSettings)

#finds the matching nested setting 
safetyGraphics:::getSettingKeys(patterns=c("ALP"),
                                settings=testSettings) 

#returns an empty list, since the only matching item is a list
safetyGraphics:::getSettingKeys(patterns=c("measure_values"),
                                settings=testSettings) 

#finds the matching key associated with a list
safetyGraphics:::getSettingKeys(patterns=c("measure_values"),
                                settings=testSettings, 
                                matchLists=TRUE) 

}
