% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe2x2Test.R
\name{simulateCoverageDifferenceTwoProportions}
\alias{simulateCoverageDifferenceTwoProportions}
\title{Simulate the coverage of a safe confidence sequence for differences between proportions
for a given distribution and safe design.}
\usage{
simulateCoverageDifferenceTwoProportions(
  successProbabilityA,
  trueDelta,
  safeDesign,
  precision = 100,
  M = 1000,
  numberForSeed = NA
)
}
\arguments{
\item{successProbabilityA}{probability of observing a success in group A.}

\item{trueDelta}{difference in probability between group A and B.}

\item{safeDesign}{a safe test design for two proportions retrieved through \code{\link{designSafeTwoProportions}()}.}

\item{precision}{precision of the grid to search over for the confidence sequence bounds. Default 100.}

\item{M}{number of simulations to carry out. Default 1000.}

\item{numberForSeed}{number for seed to set, default NA.}
}
\value{
the proportion of simulations where the trueDelta was included in the confidence sequence.
}
\description{
Simulate the coverage of a safe confidence sequence for differences between proportions
for a given distribution and safe design.
}
\examples{
balancedSafeDesign <- designSafeTwoProportions(na = 1,
                                               nb = 1,
                                               nBlocksPlan = 20)
simulateCoverageDifferenceTwoProportions(successProbabilityA = 0.2,
                                         trueDelta = 0,
                                         safeDesign = balancedSafeDesign,
                                         M = 100,
                                         precision = 20,
                                         numberForSeed = 1082021)
}
