% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{computeBetaSafeZ}
\alias{computeBetaSafeZ}
\title{Helper function: Computes the type II error based on the minimal clinically relevant mean difference and nPlan}
\usage{
computeBetaSafeZ(
  meanDiffMin,
  nPlan,
  alpha = 0.05,
  alternative = c("two.sided", "greater", "less"),
  sigma = 1,
  kappa = sigma,
  testType = c("oneSample", "paired", "twoSample"),
  parameter = NULL,
  pb = TRUE,
  nSim = 1000L,
  nBoot = 1000L
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{nPlan}{optional numeric vector of length at most 2. When provided, it is used to find the safe test
defining parameter phiS. Note that if the purpose is to plan based on nPlan alone, then both meanDiffMin
and beta should be set to NULL.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the number of samples for the safe z test under continuous monitoring,
or for the computation of the logarithm of the implied target.}
}
\value{
a list which contains at least beta and an adapted bootObject of class  \code{\link[boot]{boot}}.
}
\description{
Helper function: Computes the type II error based on the minimal clinically relevant mean difference and nPlan
}
\examples{
computeBetaSafeZ(meanDiffMin=0.7, 20, nSim=10)
}
