% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R
\docType{data}
\name{toenail.saemix}
\alias{toenail.saemix}
\title{Toenail data}
\format{
This data frame contains the following columns:
\describe{
\item{id}{subject index in file}
\item{time}{time of measurement (in months)}
\item{y}{degree of onycholysis (0 if none or mild, 1 if moderate or severe)}
\item{treatment}{treatment indicator (1=Treatment A, 0= Treatment B)}
\item{visit}{visit number (visit numbers 1-7 correspond to scheduled visits at 0, 4, 8, 12, 24, 36, and 48 weeks)}
}
#'
}
\source{
prLogistic package in R
}
\usage{
toenail.saemix
}
\description{
The \code{toenail.saemix} data are from a multicenter study comparing two oral treatments for toe-nail infection, including information for 294 patients measured at 7 weeks, comprising a total of 1908 measurements. The outcome binary variable "onycholysis" indicates the degree of separation of the nail plate from the nail-bed (none or mild versus moderate or severe). Patients were evaluated at baseline (week 0) and at weeks 4, 8, 12, 24, 36, and 48 thereafter.
}
\details{
The data in the \code{toenail.saemix} was copied from the Toenail dataset provided by the prLogistic package. Different models
and analyses have been performed to describe this dataset in Molenberg and Verbeke (2000).
Please refer to the PDF documentation (chapter 4, section 4.6) for more details on the analysis, including how to obtain diagnostic plots.
}
\examples{

data(toenail.saemix)
saemix.data<-saemixData(name.data=toenail.saemix,name.group=c("id"), name.predictors=c("time","y"), 
 name.response="y", name.covariates=c("treatment"),name.X=c("time"))
binary.model<-function(psi,id,xidep) {
  tim<-xidep[,1]
  y<-xidep[,2]
  inter<-psi[id,1]
  slope<-psi[id,2]
  logit<-inter+slope*tim
  pevent<-exp(logit)/(1+exp(logit))
  pobs = (y==0)*(1-pevent)+(y==1)*pevent
  logpdf <- log(pobs)
  return(logpdf)
}

saemix.model<-saemixModel(model=binary.model,description="Binary model",
     modeltype="likelihood",
     psi0=matrix(c(-5,-.1,0,0),ncol=2,byrow=TRUE,dimnames=list(NULL,c("theta1","theta2"))),
     transform.par=c(0,0), covariate.model=c(0,1),
     covariance.model=matrix(c(1,0,0,1),ncol=2))
\donttest{
saemix.options<-list(seed=1234567,save=FALSE,save.graphs=FALSE, displayProgress=FALSE, 
   nb.chains=10, fim=FALSE)
binary.fit<-saemix(saemix.model,saemix.data,saemix.options)
plot(binary.fit, plot.type="convergence")
}
 
}
\references{
M De Backer, C De Vroey, E Lesaffre, I Scheys, P De Keyser (1998).
Twelve weeks of continuous oral therapy for toenail onychomycosis caused by dermatophytes:
A double-blind comparative trial of terbinafine 250 mg/day versus itraconazole 200 mg/day.
Journal of the American Academy of Dermatology, 38:57-63.

E Lesaffre, B Spiessens (2001). On the effect of the number of quadrature points in a logistic random-effects model: An example.
Journal of the Royal Statistical Society, Series C, 50:325-335.

G Verbeke, G Molenberghs (2000). Linear mixed models for longitudinal data, Springer, New York.

S Rabe-Hesketh, A Skrondal (2008). Multilevel and Longitudinal Modeling Using Stata. Mahwah, NJ: Lawrence Erlbaum Associates. Second Edition.
}
\keyword{datasets}
