% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SaemixModel.R
\name{saemixModel}
\alias{saemixModel}
\title{Function to create a SaemixModel object}
\usage{
saemixModel(model, psi0, description = "", error.model = character(),
  transform.par = numeric(), fixed.estim = numeric(),
  covariate.model = matrix(nrow = 0, ncol = 0),
  covariance.model = matrix(nrow = 0, ncol = 0), omega.init = matrix(nrow =
  0, ncol = 0), error.init = numeric(), name.modpar = character(),
  verbose = TRUE)
}
\arguments{
\item{model}{name of the function used to compute the structural model. The
function should return a vector of predicted values given a matrix of
individual parameters, a vector of indices specifying which records belong
to a given individual, and a matrix of dependent variables (see example
below).}

\item{psi0}{a matrix with a number of columns equal to the number of
parameters in the model, and one (when no covariates are available) or two
(when covariates enter the model) giving the initial estimates for the fixed
effects. The column names of the matrix should be the names of the
parameters in the model, and will be used in the plots and the summaries.
When only the estimates of the mean parameters are given, psi0 may be a
named vector.}

\item{description}{a character string, giving a brief description of the
model or the analysis}

\item{error.model}{type of residual error model (valid types are constant,
proportional, combined and exponential). Defaults to constant}

\item{transform.par}{the distribution for each parameter (0=normal,
1=log-normal, 2=probit, 3=logit). Defaults to a vector of 1s (all parameters
have a log-normal distribution)}

\item{fixed.estim}{whether parameters should be estimated (1) or fixed to
their initial estimate (0). Defaults to a vector of 1s}

\item{covariate.model}{a matrix giving the covariate model. Defaults to no
covariate in the model}

\item{covariance.model}{a square matrix of size equal to the number of
parameters in the model, giving the variance-covariance matrix of the model:
1s correspond to estimated variances (in the diagonal) or covariances
(off-diagonal elements). Defaults to the identity matrix}

\item{omega.init}{a square matrix of size equal to the number of parameters
in the model, giving the initial estimate for the variance-covariance matrix
of the model. Defaults to the identity matrix}

\item{error.init}{a vector of size 2 giving the initial value of a and b in
the error model. Defaults to 1 for each estimated parameter in the error
model}

\item{name.modpar}{names of the model parameters, if they are not given as
the column names (or names) of psi0}

\item{verbose}{a boolean, controlling whether information about the created should be printed out. Defaults to TRUE}
}
\value{
A SaemixModel object (see \code{\link{saemixModel}}).
}
\description{
This function creates a SaemixModel object. The two mandatory arguments are
the name of a R function computing the model in the SAEMIX format (see
details and examples) and a matrix psi0 giving the initial estimates of the
fixed parameters in the model, with one row for the population mean
parameters and one row for the covariate effects (see documentation).
}
\details{
This function is the user-friendly constructor for the SaemixModel object
class.
}
\examples{
model1cpt<-function(psi,id,xidep) {
	  dose<-xidep[,1]
	  tim<-xidep[,2]
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption",
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu,
Marc Lavielle.
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis (2005), 49(4):1020-38.

Comets E, Lavenu A, Lavielle M. Parameter Estimation in Nonlinear Mixed Effect Models Using saemix, an R Implementation of the SAEM Algorithm. Journal of Statistical Software (2017), 80(3):1-41. doi:10.18637/jss.v080.i03
}
\seealso{
\code{\link{SaemixData}},\code{\link{SaemixModel}},
\code{\link{saemixControl}},\code{\link{saemix}}
}
\keyword{models}

