% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{getData}
\alias{getData}
\alias{getData.NER}
\title{Extract saeTrafo object data}
\usage{
\method{getData}{NER}(object, ...)
}
\arguments{
\item{object}{an object of type "NER".}

\item{...}{additional arguments that are not used in this method.}
}
\value{
Data frame used to fit the model. For "NER" the (untransformed)
sample data is returned.
}
\description{
Method \code{getData.NER} extracts the data frame used to fit the model.
}
\details{
The generic function \code{getData} is imported from package
\pkg{nlme} and re-exported to make the S3-methods available, even though the
\pkg{nlme} package itself is not loaded or attached. For default
documentation, see \code{\link[nlme]{getData}}.
}
\examples{

# Example to extract object data

# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp)

getData(NER_model)
}
\seealso{
\code{\link{NER_Trafo}}, \code{\link[nlme]{getData}}
}
