% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-agg.R
\name{agg_all}
\alias{agg_all}
\title{Aggregation function}
\usage{
agg_all(groupVars = "idD")
}
\arguments{
\item{groupVars}{variable names as character identifying groups to be aggregated.}
}
\description{
This function is intended to be used with \code{\link{sim_agg}} and not interactively. This is one implementation for aggregating data in a simulation set-up.
}
\details{
This function follows the split-apply-combine idiom. Each data set is split by the defined variables. Then the variables within each subset are aggregated (reduced to one row). Logical variables are reduced by \code{\link{any}}; for characters and factors dummy variables are created and the aggregate is the mean of each dummy; and for numerics the mean (removing NAs).
}
\examples{
sim_base() \%>\% sim_gen_x() \%>\% sim_gen_e() \%>\% sim_agg(agg_all())
}
\seealso{
\code{\link{sim_agg}}
}
