% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelIndices.R
\name{SelIndices}
\alias{SelIndices}
\title{Slices A Matrix Along A Dimension}
\usage{
SelIndices(var, posdim, limits)
}
\arguments{
\item{var}{An array with any number of dimensions.}

\item{posdim}{The dimension along which the ensemble subset should be 
selected.}

\item{limits}{The lower and upper limits for the selection of ensemble 
members along the posdim dimension.}
}
\value{
The subsetted array.
}
\description{
This function selects a subset of ensemble members from an array containing 
any number of dimensions.
}
\examples{
a <- array(rnorm(24), dim = c(2, 3, 4, 1))
print(a)
print(a[, , 2:3, ])
print(dim(a[, , 2:3, ]))
print(SelIndices(a, 3, c(2, 3)))
print(dim(SelIndices(a, 3, c(2, 3))))

}
\author{
History:\cr
0.1  -  2011-04  (V. Guemas, \email{virginie.guemas@bsc.es})  -  Original code\cr
1.0  -  2013-09  (N. Manubens, \email{nicolau.manubens@bsc.es})  -  Formatting to CRAN
}
\keyword{datagen}
