% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikChisq}
\alias{llikChisq}
\title{log likelihood and derivatives for chi-squared distribution}
\usage{
llikChisq(x, df, full = FALSE)
}
\arguments{
\item{x}{variable that is distributed by chi-squared distribution}

\item{df}{degrees of freedom (non-negative, but can be non-integer).}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with \code{dDf}
that has the derivatives with respect to the \code{df} parameter
the observation time-point
}
\description{
log likelihood and derivatives for chi-squared distribution
}
\details{
In an \code{rxode2()} model, you can use \code{llikChisq()} but you have to
use the x and df arguments.  You can also get the derivative of \code{df} with
\code{llikChisqDdf()}.
}
\examples{

\donttest{
llikChisq(1, df = 1:3, full=TRUE)

llikChisq(1, df = 6:9)

et <- et(1:3)
et$x <- 1

model <- rxode2({
   fx <- llikChisq(x, time)
   dDf <- llikChisqDdf(x, time)
})

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
