% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape.R
\name{walk_melb}
\alias{walk_melb}
\title{API using compedapi to Melbourne pedestrian data}
\usage{
walk_melb(from = to - 6L, to = Sys.Date() - 1L, tz = "", na.rm = FALSE,
  tweak = FALSE, session = NULL)
}
\arguments{
\item{from}{Starting date.}

\item{to}{Ending date.}

\item{tz}{Time zone. By default, "" is the current time zone. For this dataset,
the local time zone is "Australia/Melbourne" which would be the most
appropriate, depending on OS.}

\item{na.rm}{Logical. \code{FALSE} is the default suggesting to include \code{NA} in
the dataset. \code{TRUE} removes the \code{NA}s.}

\item{tweak}{Logical. \code{FALSE} (the default) leaves the sensor names as is. If
\code{TRUE}, they are cleaned up and matched with the ones in \link{run_melb}.}

\item{session}{\code{NULL} or "shiny". For internal use only.}
}
\value{
A data frame including these variables as follows:
\itemize{
\item Sensor: Sensor name (43 sensors up to date)
\item Date_Time: Date time when the pedestrian counts are recorded
\item Date: Date associated with Date_Time
\item Time: Time of day
\item Count: Hourly counts
}
}
\description{
Provides API using compedapi to Melbourne pedestrian data in a tidy data form.
}
\details{
It provides API using compedapi, where counts are uploaded on a
daily basis. The up-to-date data would be
till the previous day. The data is sourced from \href{https://data.melbourne.vic.gov.au/Transport-Movement/Pedestrian-volume-updated-monthly-/b2ak-trbp}{Melbourne Open Data Portal}. Please
refer to Melbourne Open Data Portal for more details about the dataset and
its policy.
}
\examples{
\dontrun{
  # Retrieve last week data
  ped_df1 <- walk_melb()
  head(ped_df1)

  # Retrieve data of a speficied period
  start_date <- as.Date("2017-07-01")
  end_date <- start_date + 6L
  ped_df2 <- walk_melb(from = start_date, to = end_date)
  head(ped_df2)
}
}
\seealso{
\link{run_melb}
}
