## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  warning = FALSE,
  message = FALSE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(rvolleydata)
library(dplyr)

## ----installation, eval=FALSE-------------------------------------------------
# # install.packages("devtools")
# devtools::install_github("awosoga/rvolleydata")

## ----schedule-----------------------------------------------------------------
load_lovb_schedule <- load_lovb_schedule(2025)
glimpse(load_lovb_schedule)

## ----player_info--------------------------------------------------------------
load_aupvb_player_info <- load_aupvb_player_info(2024)
glimpse(load_aupvb_player_info)

## ----leaderboards-------------------------------------------------------------
load_aupvb_leaderboards <- load_aupvb_leaderboards(2024)
glimpse(load_aupvb_leaderboards)

## ----aupvb_pbp----------------------------------------------------------------
load_aupvb_pbp <- load_aupvb_pbp(2024)
glimpse(load_aupvb_pbp)

## ----lovb_pbp-----------------------------------------------------------------
load_lovb_pbp <- load_lovb_pbp(2025)
glimpse(load_lovb_pbp)

## ----officials----------------------------------------------------------------
load_lovb_officials <- load_lovb_officials(2025)
glimpse(load_lovb_officials)

## ----boxscores----------------------------------------------------------------
load_lovb_player_info <- load_lovb_player_info(2025)
glimpse(load_lovb_player_info)

## ----team_staff---------------------------------------------------------------
load_lovb_team_staff <- load_lovb_team_staff(2025)
glimpse(load_lovb_team_staff)

## ----events_log---------------------------------------------------------------
load_lovb_events_log <- load_lovb_events_log(2025)
glimpse(load_lovb_events_log)

## ----player_boxscores---------------------------------------------------------
load_lovb_player_boxscores <- load_lovb_player_boxscore(2025)
glimpse(load_lovb_player_boxscores)

## ----team_boxscores-----------------------------------------------------------
load_lovb_team_boxscores <- load_lovb_team_boxscore(2025)
glimpse(load_lovb_team_boxscores)

