% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussfit.R
\name{fit3gauss}
\alias{fit3gauss}
\title{Fit Gaussians to Three Absorption Features}
\usage{
fit3gauss(wvl, flx, bnds0, bnds1, bnds2)
}
\arguments{
\item{wvl}{the vector of wavelengths of the spectrum to fit to}

\item{flx}{the vector of normalized flux of the spectrum to fit to}

\item{bnds0}{a vector of length 2 with the lower and upper bounds of the left absorption feature}

\item{bnds1}{a vector of length 2 with the lower and upper bounds of the middle absorption feature}

\item{bnds2}{a vector of length 2 with the lower and upper bounds of the right absorption feature}
}
\value{
a list with three components:
\item{mu}{the fitted value of the center parameter for the middle Gaussian}
\item{sig}{the fitted value of the spread parameter for the middle Gaussian}
\item{amp}{the fitted value of the amplitude parameter for the middle Gaussian}
}
\description{
This function takes a spectrum and the wavelength bounds of three neighboring
absorption features and uses the functions \code{gauss1func}, \code{gauss2func}, and/or
\code{gauss3func} to fit Gaussians to them simultaneously. The final fit is the first
of the following five outcomes for which the nonlinear regression algorithm
converges: (i) all three Gaussians, (ii) the left two Gaussians, (iii) the
right two Gaussians, (iv) just the middle Gaussian, (v) the middle Gaussian
with an amplitude of 0. Only the fit parameters for the middle Gaussian are
returned.
}
\examples{
x = seq(5000, 5003, length.out=200)
y = gauss3func(x, 0.3, 0.5, 0.4, 5001.5, 5002, 5000.4, 0.1, 0.1, 0.13)
y = rnorm(200, mean=y, sd=0.01)
plot(x, y)
abline(v=c(5000.8, 5001.2, 5001.75, 5002.3))
pars = fit3gauss(x, y, c(5000, 5000.8), c(5001.2, 5001.75), c(5001.75, 5002.3))
fitted = gauss1func(x, pars$amp, pars$mu, pars$sig)
lines(x, fitted, col=2)

}
