% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop_methods.R
\name{bicop_predict_and_fitted}
\alias{bicop_predict_and_fitted}
\alias{predict.bicop}
\alias{fitted.bicop}
\alias{fitted.bicop}
\title{Predictions and fitted values for a bivariate copula model}
\usage{
\method{predict}{bicop}(object, newdata, what = "pdf", ...)

\method{fitted}{bicop}(object, what = "pdf", ...)
}
\arguments{
\item{object}{a \code{bicop} object.}

\item{newdata}{points where the fit shall be evaluated.}

\item{what}{what to predict, one of \code{"pdf"}, \code{"cdf"}, \code{"hfunc1"}, \code{"hfunc2"},
\code{"hinv1"}, \code{"hinv2"}.}

\item{...}{unused.}
}
\value{
\code{fitted()} and \code{logLik()} have return values similar to \code{\link[=dbicop]{dbicop()}},
\code{\link[=pbicop]{pbicop()}}, and \code{\link[=hbicop]{hbicop()}}.
}
\description{
Predictions of the density, distribution function,
h-functions (with their inverses) for a bivariate copula model.
}
\details{
\code{fitted()} can only be called if the model was fit with the
\code{keep_data = TRUE} option.
}
\examples{
# Simulate and fit a bivariate copula model
u <- rbicop(500, "gauss", 0, 0.5)
fit <- bicop(u, "par", keep_data = TRUE)

# Predictions
all.equal(predict(fit, u, "hfunc1"), fitted(fit, "hfunc1"))
}
