% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_rv.R
\name{range.rv}
\alias{range.rv}
\title{Distribution of the Range of a Random Vector}
\usage{
\method{range}{rv}(..., na.rm = FALSE, finite = FALSE)
}
\arguments{
\item{\dots}{further arguments passed to or from other methods}

\item{na.rm}{logical, indicating if \link{NA}s should be omitted}

\item{finite}{logical, indicating if all non-finite elements should be
omitted}
}
\description{
\code{range.rv} returns a 2-component random vector containing the
distributions of the minimum and the maximum values of all the given
arguments.
}
\details{
This is the rv-compatible version of the function \code{\link{range}}.
}
\examples{

  x <- rvnorm(mean=1:10, sd=1)
  print(range(x))
  print(quantile(x, c(0,1)))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{quantile.rv}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
