% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate_mean_squared_error}
\alias{evaluate_mean_squared_error}
\alias{evaluate_mean_absolute_error}
\alias{evaluate_binary_crossentropy}
\alias{evaluate_binary_accuracy}
\alias{evaluate_kullback_leibler_divergence}
\title{Evaluation metrics}
\usage{
evaluate_mean_squared_error(learner, data, ...)

evaluate_mean_absolute_error(learner, data, ...)

evaluate_binary_crossentropy(learner, data, ...)

evaluate_binary_accuracy(learner, data, ...)

evaluate_kullback_leibler_divergence(learner, data, ...)
}
\arguments{
\item{learner}{A trained learner object}

\item{data}{Test data for evaluation}

\item{...}{Additional parameters passed to \verb{keras::\link[keras]\{evaluate\}}.}
}
\value{
A named list with the autoencoder training loss and evaluation metric for the
given data
}
\description{
Performance evaluation metrics for autoencoders
}
\examples{
x <- as.matrix(sample(iris[, 1:4]))
x_train <- x[1:100, ]
x_test <- x[101:150, ]

\donttest{
if (interactive() && keras::is_keras_available()) {
  autoencoder(2) |>
    train(x_train) |>
    evaluate_mean_squared_error(x_test)
}
}

}
\seealso{
\verb{\link{evaluation_metric}}
}
