% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sum_run}
\alias{sum_run}
\title{Running sum}
\usage{
sum_run(x, k = 0L, na_rm = TRUE, na_pad = FALSE, idx = 1L)
}
\arguments{
\item{x}{vector of any type where running sum is calculated}

\item{k}{Running window size.  Not yet implemented.}

\item{na_rm}{logical (default \code{na_rm=TRUE}) - if \code{TRUE} sum is calulating excluding \code{NA}.}

\item{na_pad}{logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.}

\item{idx}{an optional integer vector containing idx numbers of observation.}
}
\value{
numeric vector of length equals length of \code{x} containing running sum in \code{k}-long window.
}
\description{
Running sum in specified window of numeric vector.
}
\examples{
set.seed(11)
x1 <- rnorm(15)
x2 <- sample(c(rep(NA,5),rnorm(15)), 15, replace=TRUE)
k <- sample(1:15, 15, replace=TRUE)
sum_run(x1)
sum_run(x2, na_rm = TRUE)
sum_run(x2, na_rm = FALSE )
sum_run(x2, na_rm = TRUE, k=4)
}
