% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{mk_table_ind_obs}
\alias{mk_table_ind_obs}
\title{Creates Tables of Individual Observations from PKNCA Result}
\usage{
mk_table_ind_obs(
  nca_res,
  obnd = NULL,
  not_sampled = "NS",
  blq = "BLQ",
  digits = 3,
  text_format = "text",
  max_height = 7,
  max_width = 6.5,
  max_row = NULL,
  max_col = 9,
  notes_detect = NULL,
  rows_by = "time"
)
}
\arguments{
\item{nca_res}{Output of PKNCA.}

\item{obnd}{onbrand reporting object.}

\item{not_sampled}{Character string to use for missing data when pivoting.}

\item{blq}{Character string to use to indicate data below the level of quantification (value of 0 in the dataset).}

\item{digits}{Number of significant figures to report (set to \code{NULL} to disable rounding)}

\item{text_format}{Either \code{"md"} for markdown or \code{"text"} (default) for plain text.}

\item{max_height}{Maximum height of the final table in inches (A value of \code{NULL} will use 100 inches).}

\item{max_width}{Maximum width of the final table in inches (A value of \code{NULL} will use 100 inches).}

\item{max_row}{Maximum number of rows to have on a page. Spillover will hang over the side of the page..}

\item{max_col}{Maximum number of columns to have on a page. Spillover will be wrapped to multiple pages.}

\item{notes_detect}{Vector of strings to detect in output tables (example \code{c("NC", "BLQ")}).}

\item{rows_by}{Can be either "time" or "id". If it is "time", there will be a
column for time and separate column for each subject ID. If rows_by is set
to "id" there will be a column for ID and a column for each individual time.}
}
\value{
List containing the following elements
\itemize{
\item{isgood:}      Boolean indicating the exit status of the function.
\item{one_table:}   Dataframe of the entire table with the first lines containing the header.
\item{one_body:}    Dataframe of the entire table (data only).
\item{one_header:}  Dataframe of the entire header (row and body, no data).
\item{tables:}      Named list of tables. Each list element is of the output
\item{msgs:}        Vector of text messages describing any errors that were found.
format from \code{\link[onbrand]{build_span}}.
}
}
\description{
Takes the output of PKNCA and creates a tabular view of the
individual observation data. This can be spread out of over several tables
(pages) if necessary.
}
\examples{
# We need a state variable to be define
sess_res = NCA_test_mksession()

state = sess_res$state

# Pulls out the active analysis
current_ana = NCA_fetch_current_ana(state)

# This is the raw PKNCA output
pknca_res = NCA_fetch_ana_pknca(state, current_ana)

# Building the figure
mk_res = mk_table_ind_obs(nca_res = pknca_res)
mk_res$tables[["Table 1"]]$ft
}
