% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{multi_step_ahead_pred}
\alias{multi_step_ahead_pred}
\title{Multi--step--ahead predictions of the GARCH--MIDAS--based models with and without the '--X' part.}
\usage{
multi_step_ahead_pred(est, h, X = NULL)
}
\arguments{
\item{est}{The estimation object as resulting by the \code{\link{ugmfit}} function}

\item{h}{The length of the multi-step-ahead predictions}

\item{X}{\strong{optional}. The '--X' variable. NULL by default. It hat to be equal to the 'X' used in the \code{\link{ugmfit}} function}
}
\value{
The multi-step-ahead predictions, for the following h days, starting from the last day of the
chosen in-sample period adopted in the 'est' object.
}
\description{
Calculates the multi--step--ahead predictions for the GARCH--MIDAS and DAGM models, according to the procedure
suggested by \insertCite{amendola_candila_gallo_2020;textual}{rumidas}.
}
\details{
The multi--step--ahead procedure calculates the volatility predictions keeping fixed the information set at the last
observation available and projecting forward the forecasts. The procedure calculates the volatility predictions conditionally
to the parameters estimated in the in-sample period. Therefore, the estimation object (through the \code{\link{ugmfit}} function)
has to be provided. For additional details, see Eq. (20) in \insertCite{amendola_candila_gallo_2020;textual}{rumidas}.
}
\examples{
\donttest{
r_t<-sp500['2008']
X<-(rv5['2008'])^0.5
mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly") 
fit<-ugmfit(model="GMX",skew="YES",distribution="norm",r_t,mv_m,K=12,X=X)
### ten days predictions
multi_step_ahead_pred(fit,h=10,X)
}
}
\references{
\insertAllCited{}
}
