% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packs.R
\name{cell-pack}
\alias{cell-pack}
\title{Cell rule pack}
\description{
Cell rule pack is a \link[=rule-packs]{rule pack} which defines a set of rules for
cells, i.e. functions which convert cells of interest to logical values. It
should return a data frame with the following properties:
\itemize{
\item Number of rows equals to \strong{number of rows for checked cells}.
\item Column names should be treated as concatenation of
\bold{'column name of check cell' + 'separator' + 'rule name'}
\item Values indicate whether the \strong{cell} follows the rule.
}
}
\details{
This format is inspired by \link[dplyr:transmute_all]{scoped variants of transmute()}.

The most common way to define cell pack is by creating a \link[magrittr:pipe]{functional sequence} containing one of:
\itemize{
\item \code{transmute_all(.funs = rules(...))}.
\item \code{transmute_if(.predicate, .funs = rules(...))}.
\item \code{transmute_at(.vars, .funs = rules(...))}.
}

\strong{Note} that (as of \code{dplyr} version 0.7.4) when only one column is
transmuted, names of the output don't have a necessary structure. The 'column
name of check cell' is missing which results (after \link[=expose]{exposure})
into empty string in \code{var} column of \link[=ruler-report]{validation report}. The
current way of dealing with this is to name the input column (see examples).
}
\section{Using rules()}{

Using \code{\link[=rules]{rules()}} to create list of functions for scoped \code{dplyr} "mutating"
verbs (such as \link[dplyr:summarise_all]{summarise_all()} and
\link[dplyr:transmute_all]{transmute_all()}) is recommended because:
\itemize{
\item It is a convenient way to ensure consistent naming of rules without manual
name.
\item It adds a common prefix to all rule names. This helps in defining
separator as prefix surrounded by any number of non-alphanumeric values.
}
}

\section{Note about rearranging rows}{

\strong{Note} that during exposure packs are applied to \link[keyholder:keys-set]{keyed object} with \link[keyholder:keyholder-id]{id key}. So they
can rearrange rows as long as it is done with \link[keyholder:keyholder-supported-funs]{functions supported by keyholder}. Rows will be tracked and
recognized as in the original data frame of interest.
}

\examples{
cell_outlier_rules <- . \%>\% dplyr::transmute_at(
  c("disp", "qsec"),
  rules(z_score = abs(. - mean(.)) / sd(.) > 1)
)

cell_packs(outlier = cell_outlier_rules)

# Dealing with one column edge case
improper_pack <- . \%>\% dplyr::transmute_at(
  dplyr::vars(vs),
  rules(improper_is_neg = . < 0)
)

proper_pack <- . \%>\% dplyr::transmute_at(
  dplyr::vars(vs = vs),
  rules(proper_is_neg = . < 0)
)

mtcars[1:2, ] \%>\%
  expose(cell_packs(improper_pack, proper_pack)) \%>\%
  get_report()

}
\seealso{
\link[=data-pack]{Data pack}, \link[=group-pack]{group pack}, \link[=column-pack]{column pack}, \link[=row-pack]{row pack}.
}
