% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{lookup_users}
\alias{lookup_users}
\title{Get Twitter users data for given users (user IDs or screen names).}
\usage{
lookup_users(users, parse = TRUE, token = NULL)
}
\arguments{
\item{users}{User id or screen name of target user.}

\item{parse}{Logical, indicating whether or not to parse
return object into data frame(s).}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}
}
\value{
A tibble of users data.
}
\description{
Returns data on up to 90,000 Twitter users. To return data on more
than 90,000 users, code must be written to iterate through user IDs
whilst avoiding rate limits, which reset every 15 minutes.
}
\examples{

\dontrun{

## select one or more twitter users to lookup
users <- c(
  "potus", "hillaryclinton", "realdonaldtrump",
  "fivethirtyeight", "cnn", "espn", "twitter"
)

## get users data
usr_df <- lookup_users(users)

## view users data
usr_df

## view tweet data for these users via tweets_data()
tweets_data(usr_df)

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/accounts-and-users/follow-search-get-users/api-reference/get-users-lookup}

Other users: \code{\link{as_screenname}},
  \code{\link{lists_subscribers}},
  \code{\link{search_users}},
  \code{\link{tweets_with_users}}, \code{\link{users_data}}
}
\concept{users}
