% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrANOVARE.r
\name{qpcrANOVARE}
\alias{qpcrANOVARE}
\title{Relative expression (\eqn{\Delta C_T} method) analysis using ANOVA}
\usage{
qpcrANOVARE(x, numberOfrefGenes, block, alpha = 0.05, adjust = "none")
}
\arguments{
\item{x}{a data frame consisting of condition columns, target gene efficiency (E), target Gene Ct, reference 
gene efficiency and reference gene Ct values, respectively. Each Ct in the data frame is the mean of 
technical replicates. Complete amplification efficiencies of 2 was assumed in the example data for 
all wells but the calculated efficienies can be used instead.  \strong{NOTE:} Each line belongs to a separate 
individual reflecting a non-repeated measure experiment). See \href{../doc/vignette.html}{\code{vignette}}, 
section "data structure and column arrangement" for details.}

\item{numberOfrefGenes}{number of reference genes (1 or 2). Up to two reference genes can be handled.}

\item{block}{column name of the blocking factor (for correct column arrangement see example data.). 
When a qPCR experiment is done in multiple qPCR plates, variation resulting from the plates may 
interfere with the actual amount of gene expression. One solution is to conduct each plate as a 
complete randomized block so that at least one replicate of each treatment and control is present 
on a plate. Block effect is usually considered as random and its interaction with any main effect is 
not considered.}

\item{alpha}{significance level}

\item{adjust}{method for adjusting p-values}
}
\value{
A list with 4 elements:
\describe{
  \item{Final_data}{The row data plus weighed delta Ct (wDCt) values.}
  \item{lm}{The output of linear model analysis including ANOVA tables}
  \item{ANOVA}{ANOVA table based on CRD}
  \item{Result}{The result table including treatments and factors, RE (Relative Expression), LCL, UCL, 
  letter display for pair-wise comparisons and standard error with the lower and upper limits.}
}
}
\description{
Analysis of variance of relative expression (\eqn{\Delta C_T} method) values for 
all factor level combinations in the experiment in which the expression level of a 
reference gene is used as normalizer.
}
\details{
The \code{qpcrANOVARE} function performs analysis of variance (ANOVA) of relative 
expression (RE) values for all factor level combinations as treatments using the expression 
level of a reference gene is used as normalizer. To get a reliable result, the expression of 
the reference gene needs to be constant across all test samples and it expression should not 
be affected by the experimental treatment under study.
}
\examples{

# If the data include technical replicates, means of technical replicates
# should be calculated first using meanTech function.
# Applying ANOVA
qpcrANOVARE(data_3factor, numberOfrefGenes = 1, block = NULL)


qpcrANOVARE(data_2factorBlock, block = "Block", numberOfrefGenes = 1)


}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method. Methods 25 (4). doi:10.1006/meth.2001.1262.

Ganger, MT, Dietz GD, and Ewing SJ. 2017. A common base method for analysis of qPCR data
and the application of simple blocking in qPCR experiments. BMC bioinformatics 18, 1-11.

Yuan, Joshua S, Ann Reed, Feng Chen, and Neal Stewart. 2006.
Statistical Analysis of Real-Time PCR Data. BMC Bioinformatics 7 (85). doi:10.1186/1471-2105-7-85.
}
\author{
Ghader Mirzaghaderi
}
