% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip}
\alias{tip}
\title{TIP curve}
\usage{
tip(dataset, arpt.value, norm = FALSE, plot = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing variables obtained by using the setupDataset function.}

\item{arpt.value}{the at-risk-of-poverty threshold to be used  (see arpt).}

\item{norm}{logical; if  TRUE, the normalized TIP curve ordinates are computed using the normalized poverty gaps (poverty gaps divided by the poverty threshold).}

\item{plot}{logical; if TRUE plots the TIP curve.}
}
\value{
A data.frame with the following components:

x.tip vector of cumulated proportion of population.

y.tip vector with values of tip curve ordinates.
}
\description{
Estimates TIP curve ordinates. The TIP curve is defined by plotting the cumulated proportion of population on the x-axis and the cumulated per capita poverty gap (the distance between each income and the poverty threshold) on the y-axis from the biggest one downwards.
}
\details{
The TIP (Three I's of Poverty) curve ordinates are computed using the equivalized disposable income. The equivalence scales that can be employed are the modified OECD scale or the parametric scale of Buhmann et al. (1988). The default is the modified OECD scale (see setupDataset).
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT", s = "OECD")
tip.curve <- tip(ATdataset,arpt.value = arpt(ATdataset), norm = TRUE)
str(tip.curve)
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

S.P. Jenkins and P.J. Lambert (1997) Three I's of poverty curves, with an analysis of UK poverty trends, Oxford Economic Papers, 49, 317--327.
}
\seealso{
setupDataset, arpt
}

