% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useConda.R
\name{useConda}
\alias{useConda}
\alias{useConda,character-method}
\alias{useConda,SsimLibrary-method}
\alias{useConda<-}
\alias{useConda<-,logical-method}
\alias{useConda<-,SsimLibrary-method}
\title{Conda configuration of a SsimLibrary}
\usage{
useConda(ssimObject)

\S4method{useConda}{character}(ssimObject)

\S4method{useConda}{SsimLibrary}(ssimObject)

useConda(ssimObject) <- value

\S4method{useConda}{logical}(ssimObject) <- value

\S4method{useConda}{SsimLibrary}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}} object}

\item{value}{logical for whether to use Conda
environments for the given SyncroSim Library. If set to
\code{TRUE}, then Conda environments will be used. If set to \code{FALSE},
then Conda environments will not be used during runtime.}
}
\value{
Logical: whether Conda environments will be used during runtime for the given
\code{\link{SsimLibrary}}
}
\description{
Retrieves or sets the Conda configuration of a \code{\link{SsimLibrary}}.
}
\examples{
\dontrun{
# Set up a SyncroSim Session, SsimLibrary
mySession <- session()

# Retrieve Conda configuration status of the SsimLibrary
useConda(myLibrary)

# Set the Conda configuration of the SyncroSim Library
useConda(myLibrary) <- TRUE

# Only use Conda with the specified SyncroSim packages
useConda(myLibrary) <- "helloworld"

# Only use Conda with multiple specified SyncroSim packages
useConda(myLibrary) <- c("helloworld", "stsim")
}

}
