% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addon.R
\name{addon}
\alias{addon}
\alias{addon,character-method}
\alias{addon,missingOrNULL-method}
\alias{addon,Session-method}
\alias{addon,SsimObject-method}
\title{Addon(s) installed in SsimLibrary or Session}
\usage{
addon(ssimObject)

\S4method{addon}{character}(ssimObject)

\S4method{addon}{missingOrNULL}(ssimObject)

\S4method{addon}{Session}(ssimObject)

\S4method{addon}{SsimObject}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}} or 
\code{\link{Session}} object. If \code{NULL} (default), \code{session()} 
will be used}
}
\value{
A data.frame listing the addon(s) in use by the SsimLibrary or Session to 
which the object belongs.
}
\description{
Lists the addon SyncroSim package(s) associated with a 
\code{\link{SsimLibrary}} or \code{\link{Session}}.
These packages can only be used to extend existing SyncroSim base packages; 
as a result they cannot be used to create new SsimLibraries.
For example, \emph{stsimsf} is an addon for \emph{stsim} which provides optional 
additional functionality for the base ST-Sim model.
More information on addons can be found in the 
\href{http://docs.syncrosim.com/how_to_guides/package_addon.html}{syncrosim documentation}.
}
\examples{
\donttest{
# Install the base package "stsim"
addPackage("stsim")

# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib")

# Set the SyncroSim Session and SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Retrieve a data.frame of available add-on(s) for the SsimLibrary
addon(myLibrary)
}

}
