% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_significance.R
\name{add_significance}
\alias{add_significance}
\title{Add P-value Significance Symbols}
\usage{
add_significance(data, p.col, output.col, cutpoints = c(0, 1e-04, 0.001,
  0.01, 0.05, 1), symbols = c("****", "***", "**", "*", "ns"))
}
\arguments{
\item{data}{a data frame containing a p-value column.}

\item{p.col}{column name containing p-values.}

\item{output.col}{the output column name to hold the adjusted p-values.}

\item{cutpoints}{numeric vector used for intervals.}

\item{symbols}{character vector, one shorter than cutpoints, used as
significance symbols.}
}
\value{
a data frame
}
\description{
Add p-value significance symbols into a data frame.
}
\examples{
# Perform pairwise comparisons and adjust p-values
ToothGrowth \%>\%
 t_test(len ~ dose) \%>\%
 adjust_pvalue() \%>\%
 add_significance("p.adj")

}
