% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items-funs.R
\name{items_functions}
\alias{items_functions}
\alias{items_length}
\alias{items_length.doc_items}
\alias{items_matched}
\alias{items_matched.doc_items}
\alias{items_fetch}
\alias{items_fetch.doc_items}
\alias{items_next}
\alias{items_next.doc_items}
\alias{items_datetime}
\alias{items_datetime.doc_item}
\alias{items_datetime.doc_items}
\alias{items_bbox}
\alias{items_bbox.doc_item}
\alias{items_bbox.doc_items}
\alias{items_assets}
\alias{items_assets.doc_item}
\alias{items_assets.doc_items}
\alias{items_assets.default}
\alias{items_filter}
\alias{items_filter.doc_items}
\alias{items_compact}
\alias{items_compact.doc_items}
\alias{items_reap}
\alias{items_reap.doc_item}
\alias{items_reap.doc_items}
\alias{items_reap.default}
\alias{items_fields}
\alias{items_fields.doc_item}
\alias{items_fields.doc_items}
\alias{items_sign}
\alias{items_sign.doc_item}
\alias{items_sign.doc_items}
\alias{items_sign.default}
\alias{items_as_sf}
\alias{items_as_sf.doc_item}
\alias{items_as_sf.doc_items}
\alias{items_as_sfc}
\alias{items_as_sfc.doc_item}
\alias{items_as_sfc.doc_items}
\alias{items_as_tibble}
\alias{items_as_tibble.doc_item}
\alias{items_as_tibble.doc_items}
\alias{items_intersects}
\alias{items_intersects.doc_item}
\alias{items_intersects.doc_items}
\alias{items_properties}
\alias{items_properties.doc_item}
\alias{items_properties.doc_items}
\alias{items_select}
\alias{items_select.doc_items}
\title{Items functions}
\usage{
items_length(items)

\method{items_length}{doc_items}(items)

items_matched(items, matched_field = NULL)

\method{items_matched}{doc_items}(items, matched_field = NULL)

items_fetch(items, ...)

\method{items_fetch}{doc_items}(items, ..., progress = TRUE, matched_field = NULL)

items_next(items, ...)

\method{items_next}{doc_items}(items, ...)

items_datetime(items)

\method{items_datetime}{doc_item}(items)

\method{items_datetime}{doc_items}(items)

items_bbox(items)

\method{items_bbox}{doc_item}(items)

\method{items_bbox}{doc_items}(items)

items_assets(items)

\method{items_assets}{doc_item}(items)

\method{items_assets}{doc_items}(items)

\method{items_assets}{default}(items)

items_filter(items, ..., filter_fn = NULL)

\method{items_filter}{doc_items}(items, ..., filter_fn = NULL)

items_compact(items)

\method{items_compact}{doc_items}(items)

items_reap(items, field, pick_fn = identity)

\method{items_reap}{doc_item}(items, field, pick_fn = identity)

\method{items_reap}{doc_items}(items, field, pick_fn = identity)

\method{items_reap}{default}(items, field, pick_fn = identity)

items_fields(items, field = NULL)

\method{items_fields}{doc_item}(items, field = NULL)

\method{items_fields}{doc_items}(items, field = NULL)

items_sign(items, sign_fn)

\method{items_sign}{doc_item}(items, sign_fn)

\method{items_sign}{doc_items}(items, sign_fn)

\method{items_sign}{default}(items, sign_fn)

items_as_sf(items, ..., crs = 4326)

\method{items_as_sf}{doc_item}(items, ..., crs = 4326)

\method{items_as_sf}{doc_items}(items, ..., crs = 4326)

items_as_sfc(items, crs = 4326)

\method{items_as_sfc}{doc_item}(items, crs = 4326)

\method{items_as_sfc}{doc_items}(items, crs = 4326)

items_as_tibble(items)

\method{items_as_tibble}{doc_item}(items)

\method{items_as_tibble}{doc_items}(items)

items_intersects(items, geom, ..., crs = 4326)

\method{items_intersects}{doc_item}(items, geom, ..., crs = 4326)

\method{items_intersects}{doc_items}(items, geom, ..., crs = 4326)

items_properties(items)

\method{items_properties}{doc_item}(items)

\method{items_properties}{doc_items}(items)

items_select(items, selection)

\method{items_select}{doc_items}(items, selection)
}
\arguments{
\item{items}{a \code{doc_items} object.}

\item{matched_field}{a \code{character} vector with the path
where the number of items returned in the named list is located starting
from the initial node of the list. For example, if the information is in a
position \code{items$meta$found} of the object, it must be passed as the
following parameter \code{c("meta", "found")}.}

\item{...}{additional arguments. See details.}

\item{progress}{a \code{logical} indicating if a progress bar must be
shown or not. Defaults to \code{TRUE}.}

\item{filter_fn}{a \code{function} that receives an item that should
evaluate a \code{logical} value.}

\item{field}{a \code{character} with the names of the field to
get the subfields values.}

\item{pick_fn}{a \code{function} used to pick elements from items
addressed by \code{field} parameter.}

\item{sign_fn}{a \code{function} that receives an item as a parameter
and returns an item signed.}

\item{crs}{a \code{character} representing the geometry projection.}

\item{geom}{a \code{sf} or \code{sfc} object.}

\item{selection}{an \code{integer} vector containing the indices of the items
to select.}
}
\value{
\itemize{
\item \code{items_length()}: an \code{integer} value.

\item \code{items_matched()}: returns an \code{integer} value if the STAC web server
does support this extension. Otherwise returns \code{NULL}.

\item \code{items_fetch()}: a \code{doc_items} with all matched items.

\item \code{items_next()}: fetches a new page from STAC service.

\item \code{items_datetime()}: a \code{list} of all items' datetime.

\item \code{items_bbox()}: returns a \code{list} with all items' bounding boxes.

\item \code{item_assets()}: returns a \code{character} value with all assets names
of all items.

\item \code{items_filter()}: a \code{doc_items} object.

\item \code{items_reap()}: a \code{vector} if the supplied field is atomic,
otherwise or a \code{list}.

\item \code{items_fields()}: a \code{character} vector.

\item \code{items_sign()}: a \code{doc_items} object with signed assets url.

\item \code{items_as_sf()}: a \code{sf} object.

\item \code{items_as_sfc()}: a \code{sfc} object.

\item \code{items_as_tibble()}: a \code{tibble} object.

\item \code{items_intersects()}: a \code{logical} vector.

\item \code{items_properties()}: returns a \code{character} value with all properties
of all items.

\item \code{items_select()}: select features from an items object.

}
}
\description{
These functions provide support to work with
\code{doc_items} and \code{doc_item} objects.

\itemize{
\item \code{items_length()}: shows how many items there are in
the \code{doc_items} object.

\item \code{items_matched()}: shows how many items matched the
search criteria. It supports \code{search:metadata} (v0.8.0),
\code{context} (v0.9.0), and \code{numberMatched} (OGC WFS3 core spec).

\item \code{items_fetch()}: request all STAC Items through
pagination.

\item \code{items_next()}: fetches a new page from STAC service.

\item \code{items_datetime()}: retrieves the \code{datetime}
field in \code{properties} from \code{doc_items} and
\code{doc_item} objects.

\item \code{items_bbox()}: retrieves the \code{bbox}
field of a \code{doc_items} or a \code{doc_item} object.

\item \code{item_assets()}: returns the assets name from
\code{doc_items} and \code{doc_item} objects.

\item \code{items_filter()}: selects only items that match some criteria
(see details section).

\item \code{items_reap()}: extract key values by traversing all items
in a \code{doc_items} object.

\item \code{items_fields()}: lists field names inside an item.

\item \code{items_sign()}: allow access assets by preparing its url.

\item \code{items_as_sf()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} convert items
to \code{sf} object.

\item \code{items_as_sfc()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} convert items
to \code{sfc} object.

\item \code{items_intersects()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} indicates
which items intersects a given geometry.

\item \code{items_properties()}: lists properties names inside an item.

}
}
\details{
Ellipsis argument (\code{...}) appears in different items functions and
has distinct purposes:
\itemize{
\item \code{items_matched()} and \code{items_assets()}: ellipsis is not used.

\item \code{items_fetch()} and \code{items_next()}: ellipsis is used to pass
additional \code{httr} options to \link[httr:GET]{GET} or \link[httr:POST]{POST}
methods, such as \link[httr:add_headers]{add_headers} or
\link[httr:set_cookies]{set_cookies}.

\item \code{items_filter()}: ellipsis is used to pass logical
expressions to be evaluated against a \code{doc_item} field as filter criteria.

\strong{WARNING:} the evaluation of filter expressions changed in \code{rstac} 0.9.2.
Older versions of \code{rstac} used \code{properties} field to evaluate filter
expressions. Below, there is an example of how to write expressions in new
\code{rstac} version:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# expression in older version
items_filter(stac_obj, `eo:cloud_cover` < 10)
# now expressions must refer to properties explicitly
items_filter(stac_obj, properties$`eo:cloud_cover` < 10)
items_filter(stac_obj, properties[["eo:cloud_cover"]] < 10)
}\if{html}{\out{</div>}}

\item \code{items_sign()}: in the near future, ellipsis will be used to append
key-value pairs to the url query string of an asset.
}

\code{items_sign()} has \code{sign_fn} parameter that must be a function that
receives as argument an item and returns a signed item. \code{rstac} provides
\code{sign_bdc()} and \code{sign_planetary_computer()} functions to access Brazil
Data Cube products and Microsoft Planetary Computer catalogs, respectively.
}
\examples{
\dontrun{
 x <- stac("https://brazildatacube.dpi.inpe.br/stac") \%>\%
     stac_search(collections = "CB4-16D-2") \%>\%
     stac_search(datetime = "2020-01-01/2021-01-01", limit = 500) \%>\%
     get_request()

 x \%>\% items_length()
 x \%>\% items_matched()
 x \%>\% items_datetime()
 x \%>\% items_bbox()
 x \%>\% items_fetch()
}

\dontrun{
# Defining BDC token
Sys.setenv("BDC_ACCESS_KEY" = "token-123")

# doc_item object
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
    stac_search(collections = "CB4-16D-2", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206, -14.195, -45.067, -12.272)) \%>\%
    get_request() \%>\% items_sign(sign_fn = sign_bdc())

}

\dontrun{
# doc_items object
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
    stac_search(collections = "CB4-16D-2", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206, -14.195, -45.067, -12.272)) \%>\%
    get_request() \%>\%
    items_filter(properties$`eo:cloud_cover` < 10)

# Example with AWS STAC
stac("https://earth-search.aws.element84.com/v0") \%>\%
  stac_search(collections = "sentinel-s2-l2a-cogs",
              bbox = c(-48.206, -14.195, -45.067, -12.272),
              datetime = "2018-06-01/2018-06-30",
              limit = 500) \%>\%
  post_request() \%>\%
  items_filter(filter_fn = function(x) {x$properties$`eo:cloud_cover` < 10})
}

\dontrun{
# doc_items object
stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4-16D-2", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206, -14.195, -45.067, -12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

stac_item \%>\% items_reap(field = c("properties", "datetime"))

stac_item \%>\% items_as_sf()

stac_item \%>\% items_as_tibble()

stac_item \%>\% items_select(c(1, 4, 10, 20))

}

}
