% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R, R/query-funs.R
\name{extensions}
\alias{extensions}
\alias{before_request}
\alias{after_response}
\alias{parse_params}
\alias{content_response}
\alias{check_query_verb}
\alias{check_query}
\alias{subclass}
\alias{set_query_endpoint}
\alias{rstac_query}
\title{Extension development functions}
\usage{
before_request(q)

after_response(q, res)

parse_params(q, params)

content_response(res, status_codes, content_types, key_message)

check_query_verb(q, verbs, msg = NULL)

check_query(x, classes = NULL)

subclass(x)

set_query_endpoint(q, endpoint, params = NULL)

rstac_query(version = NULL, base_url, params = list(), subclass)
}
\arguments{
\item{q}{a \code{rstac_query} object.}

\item{res}{a \code{httr} \code{response} object.}

\item{params}{a named \code{list} with all URL query parameters to be
appended in the URL.}

\item{status_codes}{a \code{character} vector with successful
status codes.}

\item{content_types}{a \code{character} vector with all acceptable
responses' content type.}

\item{key_message}{a \code{character} vector with the JSON keys to show the
requested API message.}

\item{verbs}{a \code{character} vector with allowed HTTP request methods}

\item{msg}{a \code{character} with a personalized error message}

\item{x}{a \code{rstac_query} object expressing a STAC query
criteria.}

\item{classes}{a \code{character} vector with all allowed S3 sub-classes}

\item{endpoint}{a \code{character} vector with the format string with the
endpoint url.}

\item{version}{a \code{character} with the STAC version.}

\item{base_url}{a \code{character} informing the base URL of a
STAC web service.}

\item{subclass}{a \code{character} corresponding to the subclass of the
object to be created.}
}
\value{
A \code{rstac_query} object for \code{before_request()} and
\code{after_response()} functions.

The \code{content_response()} function returns a \code{list} data structure
representing the JSON file received in HTTP response

The \code{rstac_query()} function returns a \code{STACQuery} object with
subclass defined by \code{subclass} parameter.
}
\description{
Currently, there are five STAC documents defined in STAC spec:
\itemize{
\item \code{doc_catalog}
\item \code{doc_collection}
\item \code{doc_collections}
\item \code{doc_item}
\item \code{doc_items}
}

Each document class is associated with STAC API endpoints.
As soon as new STAC documents are proposed in the specification, new
classes can be created in the \code{rstac} package.

Let \code{version} parameter \code{NULL} to detect version automatically.

Basically, there are two types of extensions in STAC specification:
\enumerate{
\item STAC documents extensions: these extensions can be defined in
different elements of the document specification.
\item STAC API extensions: these extensions are associated with the
interaction between the client and server through API and may add new
elements in the STAC documents or just filter the elements to be returned
in the documents.
}
Here, we will focus on the second type of extension.

To let \code{rstac} package perform some behavior according to an
STAC API extension we need define some functions. These functions
can be implemented in three environments:
\enumerate{
\item In \code{rstac} package by including new functions make a
GitHub pull request on \code{rstac} repository
(\url{https://github.com/brazil-data-cube/rstac})
\item In a new package by using \code{rstac} as dependent package
\item In a script that loads \code{rstac} into the environment
}
All these places may impose specific requirements, however the core
logic to implement an extension is the same.

These functions are intended for those who want to implement new STAC API
extensions. An extension must define a subclass name and implement all the
following S3 generic methods for that subclass:
\itemize{
\item \code{before_request()}: allows handling query parameters before
submit them to the HTTP server, usually sets up the query endpoint;
\item \code{after_request()}: allows to check and parse document received
by the HTTP server;
}

These methods will work 'behind the scenes' when a \code{rstac_query} object
representing a user query are passed to a request function
(e.g. \code{get_request()} or \code{post_request()}). The calling order is:
\enumerate{
\item begin of \code{get_request()} or \code{post_request()}
\item if STAC API version is not defined, try detect it
\item call \code{before_request()}
\item send HTTP request
\item receive HTTP response
\item \code{after_response()}
\item end of \code{get_request()} or \code{post_request()}
}

Besides that, the extension must expose a function to receive user
parameters and return a \code{rstac_query} object with a subclass
associated with the above S3 methods. This function must accept as its
first parameter a \code{rstac_query} object representing the actual query.
To keep the command flow consistency, the function needs to check the
subclass of the input query. After that, it must set new or changes the
input query parameters according to the user input and, finally,
return the new query as a \code{rstac_query} object.

You can see examples on how to implement an STAC API extension by looking at
\code{stac.R}, \code{collections.R}, \code{items.R}, \code{stac_search.R},
and \code{ext_query.R} source files. These files implement core STAC API
endpoints, as well as the query API extension.

There are also some utility functions described in \strong{Functions}
section bellow that can help the extension development.
}
\section{Functions}{
\itemize{
\item \code{content_response()}: The \code{content_response} function checks if the request's
response is in accordance with the allowed status codes and content-types.
It returns the parsed content response.

\item \code{check_query_verb()}: The \code{check_query_verb()} function allows you to define which HTTP
verbs are allowed. It is useful for establishing which verbs will be
supported by an extension.

\item \code{check_query()}: The \code{check_query()} function specifies which type of query
object (\code{rstac_query}) is expected in the function extension.

\item \code{subclass()}: The \code{subclass()} function returns a \code{character} representing the
subclass name of \code{rstac_query} objects.

\item \code{set_query_endpoint()}: The \code{set_query_endpoint()} function defines the endpoint of a query.
If \code{params} parameter is passed, each value must be an entry of params
field of the given query. The corresponding param value will be used as
value replacement of \verb{\%s} occurrences in the \code{endpoint} string. After
the replacement, all params in this list will be removed.

\item \code{rstac_query()}: The \code{rstac_query()} function is a constructor of \code{rstac_query}
objects. Every extension must implement a subclass of \code{rstac_query} to
represent its queries. This is done by informing to the \code{subclass}
parameter the extension's subclass name.

The \code{params} parameter is a named \code{list} where user parameters
must be stored. It is important to know if previous query parameters needs
to be keeped in the new query. If so, it is recommended do use
\code{\link[utils:modifyList]{utils::modifyList()}} function to merge the old and new
query parameters.

If the \code{version} parameter is \code{NULL}, \code{rstac} will detect
STAC API version automatically.

In general, if you are implementing a new subclass, the parameters
\code{version} and \code{url} will be the same as the previous query. The
\code{params} parameter will be merged with previous query. And subclass
is the extension's subclass name.

}}
\seealso{
\code{\link[=ext_query]{ext_query()}}
}
\keyword{internal}
