% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asym3.R
\name{asym3}
\alias{asym3}
\title{This generates a class of asymmetric rotatable response surface designs with neighbour effects under a polynomial model of order max(s1,s2)-1}
\usage{
asym3(s1, n1, s2, n2, s3, c)
}
\arguments{
\item{s1}{Number of levels of n1 factors, 1<s1<=8}

\item{n1}{Number of factors possesses s1 levels, 1<=n1<=4}

\item{s2}{Number of levels of n2 factors, 1<s2<=8}

\item{n2}{Number of factors possesses s2 levels, 1<=n2<=4}

\item{s3}{Number of levels of one factor, 1<s3<=8}

\item{c}{Value of alpha (Coefficient of neighbour effects), 0<=c<=1}
}
\value{
his function generates rotatable designs as well as Z_prime_Z matrix,
inv(Z_primeZ) matrix and variance estimated response for the (s1^n1 * s2^n2) factorial combination.
}
\description{
This function generates asymmetrical rotatable response surface designs in the presence of neighbour effects for (n1 + n2) factors, n1 factors at s1 levels and another n2 factors at s2 levels.
}
\note{
Here s1 and s2 should not be multiple of each other.
}
\examples{
library(rsdNE)
asym3(2,2,3,2,5,0.5)
}
\references{
Dalal, 2021, Unpublished M.Sc. Thesis, IARI, New Delhi
}
\author{
Ashutosh Dalal, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Seema Jaggi, Education Division, ICAR, Krishi Anusandhan Bhawan - II, Pusa, New Delhi.
Eldho Varghese,Fishery Resources Assessment Division,ICAR-CMFRI, Kochi.
Subhasish Sarkar, Division of Computer Application,ICAR-IASRI, New Delhi.
Arpan Bhowmik, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Cini Varghese, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Anindita Datta, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Soumen Pal, Division of Computer Application,ICAR-IASRI, New Delhi.
}
