% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployTFModel.R
\name{deployTFModel}
\alias{deployTFModel}
\title{Deploy a TensorFlow saved model}
\usage{
deployTFModel(modelDir, ...)
}
\arguments{
\item{modelDir}{Path to the saved model directory. MUST contain \emph{saved_model.pb} or
\emph{saved_model.pbtxt}}

\item{...}{Additional arguments to \code{\link{deployApp}}.}
}
\description{
Deploys a directory containing a Tensorflow saved model file. A saved model directory might look like this:
\preformatted{
./1/
./1/saved_model.pb or ./1/saved_model.pbtxt
./1/variables/
./1/variables/variables.data-00000-of-00001
./1/variables/variables.index
}
For information on creating saved models, see the Keras method
\code{\link[keras]{export_savedmodel.keras.engine.training.Model}} or the TensorFlow method
\code{\link[tensorflow]{export_savedmodel}}. If using the TensorFlow package for R, the official
TensorFlow guide for saving and restoring models may be useful:
\url{https://www.tensorflow.org/programmers_guide/saved_model#overview_of_saving_and_restoring_models}
}
\details{
Deploy a single Tensorflow saved model as a bundle. Should be passed a directory that contains the
  \emph{saved_model.pb} or \emph{saved_model.pbtxt} file, as well as any variables and assets
  necessary to load the model.
}
