% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaType.R
\docType{data}
\name{scalaType}
\alias{scalaType}
\alias{stI0}
\alias{stD0}
\alias{stL0}
\alias{stR0}
\alias{stS0}
\alias{stI1}
\alias{stD1}
\alias{stL1}
\alias{stR1}
\alias{stS1}
\alias{stI2}
\alias{stD2}
\alias{stL2}
\alias{stR2}
\alias{stS2}
\title{Get or Specify a Scala Type}
\format{
See 'Value' below.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.

An object of class \code{rscalaType} of length 1.
}
\usage{
scalaType(type)

stI0

stD0

stL0

stR0

stS0

stI1

stD1

stL1

stR1

stS1

stI2

stD2

stL2

stR2

stS2
}
\arguments{
\item{type}{An rscala reference or a character vector of length one giving a
Scala type.}
}
\value{
An object of class \code{rscalaType} whose value is a character
  vector of length one indicating a Scala type.
}
\description{
This function gets the Scala type of an rscala reference.  It also, together
with the associated convenience objects, specifies a Scala type for
transcompilation purposes.
}
\details{
The convenience objects are of the form \code{stXY} (where \code{X} is in
\code{{I, D, L, R, S}} and \code{Y} is in \code{{0, 1, 2}}) as as indicated
below:

\itemize{
  \item \code{I} corresponds to Scala's \code{Int} and R's \code{integer}.
  \item \code{D} corresponds to Scala's \code{Double} and R's \code{double}.
  \item \code{L} corresponds to Scala's \code{Boolean} and R's \code{logical}.
  \item \code{R} corresponds to Scala's \code{Byte} and R's \code{raw}.
  \item \code{S} corresponds to Scala's \code{String} and R's \code{character}.
}
  
\itemize{
  \item \code{0} corresponds to a Scala primitive and an R length one vector.
  \item \code{1} corresponds to a Scala array and an R vector.
  \item \code{2} corresponds to a Scala array of arrays and an R matrix.
}

For example, \code{stS2} is equivalent to Scala's
\code{scalaType("Array[Array[String]]")} and R's type for
\code{matrix(character())}.  Also, \code{stL1} is equivalent to Scala's
\code{scalaType("Boolean")} and R's type for \code{logical(1)}.
}
\examples{
scalaType("Double")
stD0
scalaType("Array[Byte]")
stR1
scalaType("Array[Array[Int]]")
stI2

}
\keyword{datasets}
