/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import java.io.Serializable;
import java.math.BigInteger;
import rreval.MD5Util;
import rreval.MessageType;

public class Message
implements Serializable {
    static final long serialVersionUID = 1L;
    public static String CONNECT_TO_RRESERVER = "connect to RReServer";
    public static String HAS_CONNECTED = "has connected to RReServer";
    public static String RRESERVER_NOT_AVAILABLE = "The RReServer is not available";
    public static String DISCONNECT_FROM_CLIENT_APP = "disconnect from client app";
    public MessageType type;
    public String obj;
    public BigInteger md5;

    public Message(MessageType type, String obj, BigInteger md5) {
        this.type = type;
        this.obj = obj;
        this.md5 = md5;
    }

    public Message(MessageType type, String obj) {
        this.type = type;
        this.obj = obj;
        this.md5 = MD5Util.calcMD5(obj);
    }

    public String toString() {
        return "type=" + (Object)((Object)this.type) + " md5=" + this.md5.toString(16) + " length=" + this.obj.length() + " " + this.toShortString(this.obj);
    }

    public boolean isMessageToR() {
        return MessageType.mr.equals((Object)this.type);
    }

    public boolean isAppCmd() {
        return MessageType.cj.equals((Object)this.type);
    }

    public boolean isRReServerCmd() {
        return MessageType.cr.equals((Object)this.type);
    }

    private String toShortString(String s) {
        return s.substring(0, Math.min(s.length() - 1, 64));
    }

    public boolean isConnectedMessage() {
        return MessageType.rj.equals((Object)this.type) && HAS_CONNECTED.equals(this.obj);
    }

    public boolean isNotAvailableMessage() {
        return MessageType.rj.equals((Object)this.type) && RRESERVER_NOT_AVAILABLE.equals(this.obj);
    }

    public boolean isConnectCmdMessage() {
        return MessageType.cj.equals((Object)this.type) && HAS_CONNECTED.equals(this.obj);
    }

    public boolean isDisonnectCmdMessage() {
        return MessageType.cj.equals((Object)this.type) && DISCONNECT_FROM_CLIENT_APP.equals(this.obj);
    }

    public static Message createConnectToRReServerMessage() {
        return new Message(MessageType.cj, CONNECT_TO_RRESERVER);
    }

    public static Message createRReServerNotAvailableMessage() {
        return new Message(MessageType.rj, RRESERVER_NOT_AVAILABLE);
    }

    public static Message createConnectedToRReServerMessage() {
        return new Message(MessageType.rj, CONNECT_TO_RRESERVER);
    }

    public static Message createDisconnectFromClientMessage() {
        return new Message(MessageType.cj, DISCONNECT_FROM_CLIENT_APP);
    }
}

