% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refine_delete.R
\name{refine_delete}
\alias{refine_delete}
\title{Delete project from OpenRefine}
\usage{
refine_delete(project.name = NULL, project.id = NULL, force = FALSE, ...)
}
\arguments{
\item{project.name}{Name of project to be deleted}

\item{project.id}{Unique identifier for open refine project to be deleted}

\item{force}{Boolean indicating whether or not the prompt to confirm deletion should be skipped; default is \code{FALSE}}

\item{...}{Additional parameters to be inherited by \code{\link{refine_path}}; allows users to specify \code{host} and \code{port} arguments if the OpenRefine instance is running at a location other than \verb{http://127.0.0.1:3333}}
}
\value{
Operates as a side-effect to delete the project. Issues a message that the project has been deleted.
}
\description{
This function allows users to delete a project in OpenRefine by name or unique project identifier. By default users are prompted to confirm deletion. The function wraps the OpenRefine API \verb{/command/core/delete-project} query.
}
\examples{
\dontrun{
fp <- system.file("extdata", "lateformeeting.csv", package = "rrefine")
refine_upload(fp, project.name = "lfm")
refine_delete("lfm", force = TRUE)
}

}
\references{
\url{https://github.com/OpenRefine/OpenRefine/wiki/OpenRefine-API#delete-project}
}
