% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_occ_country.R
\name{rl_occ_country}
\alias{rl_occ_country}
\title{Get country occurrence by species name or ID}
\usage{
rl_occ_country(name = NULL, id = NULL, region = NULL, key = NULL,
  parse = TRUE, ...)
}
\arguments{
\item{name}{(character) Binomial taxonomic name}

\item{id}{(character) IUCN id}

\item{region}{(character) Binomial taxonomic name}

\item{key}{A IUCN API token}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get country occurrence by species name or ID
}
\examples{
\dontrun{
rl_occ_country('Loxodonta africana')
rl_occ_country('Fratercula arctica', region = 'europe')
rl_occ_country(id = 12392)
rl_occ_country(id = 22694927, region = 'europe')

rl_occ_country('Fratercula arctica', parse = FALSE)
rl_occ_country_('Fratercula arctica')
rl_occ_country_('Fratercula arctica', region = 'europe')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}

