% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize.R
\name{materialize_sql}
\alias{materialize_sql}
\title{Materialize a user supplied SQL statement as a table.}
\usage{
materialize_sql(db, sql, table_name = mk_tmp_name_source("rqms")(), ...,
  overwrite = TRUE, temporary = FALSE)
}
\arguments{
\item{db}{database connecton (rquery_db_info class or DBI connections preferred).}

\item{sql}{character, user supplied SQL statement.}

\item{table_name}{character, name of table to create.}

\item{...}{force later arguments to bind by name.}

\item{overwrite}{logical if TRUE drop an previous table.}

\item{temporary}{logical if TRUE try to create a temporary table.}
}
\value{
table description
}
\description{
Run the data query with a CREATE TABLE AS .
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2),
                   temporary = TRUE, overwrite = TRUE)
  t <- materialize_sql(my_db, "SELECT AUC, R2, AUC - R2 AS d FROM d")
  print(t)
  print(execute(my_db, t))

  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{db_td}}, \code{\link{materialize}}, \code{\link{to_sql}}, \code{\link{rq_copy_to}}, \code{\link{mk_td}}
}
\keyword{internal}
