% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mdlist}
\alias{mdlist}
\title{Create a markdown list for answer options}
\usage{
mdlist(vect, solutions = NULL, gaps = NULL)
}
\arguments{
\item{vect}{A string or numeric vector of answer options for single/multiple
choice task.}

\item{solutions}{An integer value, optional; indexes of right answer options
in \code{vect}.}

\item{gaps}{numeric or string vector, optional; provides primitive
gap description if there is a need to build a list of gaps.}
}
\value{
A markdown list.
}
\description{
Create a markdown list for answer options
}
\examples{
#list for multiple choice task
mdlist(c("A", "B", "C"), c(2, 3))
# it returns:
#- A
#- *B*
#- *C*
#list of gaps
mdlist(c("A", "B", "C"), c(2, 3), c(1, 2, 3))
# it returns:
#- A <gap>1</gap>
#- *B* <gap>2</gap>
#- *C* <gap>3</gap>
}
\seealso{
\code{\link[=gap_text]{gap_text()}}, \code{\link[=gap_numeric]{gap_numeric()}}, \code{\link[=dropdown]{dropdown()}}
}
