% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{dropdown}
\alias{dropdown}
\title{Create YAML string for InlineChoice object (dropdown list)}
\usage{
dropdown(
  choices,
  solution_index = 1,
  points = 1,
  shuffle = TRUE,
  response_identifier = NULL
)
}
\arguments{
\item{choices}{A numeric or character vector; contains values of possible
answers. If you use a named vector, the names will be used as identifiers.}

\item{solution_index}{An integer value, optional; the number of right answer
in the \code{choices} vector. Default is \code{1}.}

\item{points}{A numeric value, optional; the number of points for this gap.
Default is \code{1}.}

\item{shuffle}{A boolean, optional; is responsible to randomize the order in
which the choices are initially presented to the candidate. Default is
\code{TRUE}.}

\item{response_identifier}{A character string, optional; an identifier for
the answer.}
}
\value{
A character string mapped as yaml.
}
\description{
Create YAML string for InlineChoice object (dropdown list)
}
\examples{
dropdown(c("Option A", "Option B"), response_identifier = "task_dd_list")

}
\seealso{
\code{\link[=gap_text]{gap_text()}}, \code{\link[=gap_numeric]{gap_numeric()}}, \code{\link[=mdlist]{mdlist()}}
}
