% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criterion.R, R/has-file.R
\name{root_criterion}
\alias{as.root_criterion}
\alias{as.root_criterion.character}
\alias{as.root_criterion.root_criterion}
\alias{has_file}
\alias{has_file_pattern}
\alias{is.root_criterion}
\alias{root_criterion}
\title{Is a directory the project root?}
\usage{
root_criterion(testfun, desc)

is.root_criterion(x)

as.root_criterion(x)

\method{as.root_criterion}{character}(x)

\method{as.root_criterion}{root_criterion}(x)

has_file(filepath, contents = NULL, n = -1L)

has_file_pattern(pattern, contents = NULL, n = -1L)
}
\arguments{
\item{testfun}{A function with one parameter that returns \code{TRUE}
if the directory specified by this parameter is the project root,
and \code{FALSE} otherwise}

\item{desc}{A textual description of the test criterion}

\item{x}{An object}

\item{filepath}{File path (can contain directories)}

\item{contents}{Regular expression to match the file contents}

\item{n}{integer.  The (maximal) number of lines to
    read.  Negative values indicate that one should read up to the end of
    input on the connection.}

\item{pattern}{Regular expression to match the file name}
}
\description{
Objects of the \code{root_criterion} class decide if a
given directory is a project root.
}
\details{
Construct criteria using \code{root_criterion} in a very general fashion
by specifying a function with a \code{path} argument, and a description.

The \code{as.root_criterion} function accepts objects of class
\code{root_criterion}, and character values; the latter will be
converted to criteria using \code{has_file}.

The \code{has_file} function constructs a criterion that checks for the
existence of a specific file (which itself can be in a subdirectory of the
root) with specific contents.

The \code{has_file_pattern} function constructs a criterion that checks for the
existence of a file that matches a pattern, with specific contents.
}

