\name{split.by.feature.msa}
\alias{split.by.feature.msa}
\title{Split an MSA by feature}
\usage{
  \method{split}{by.feature.msa} (x, f, drop = FALSE,
    pointer.only = FALSE, ...)
}
\arguments{
  \item{x}{An object of type \code{msa}}

  \item{f}{An object of type \code{feat}}

  \item{drop}{Not currently used}

  \item{pointer.only}{If \code{TRUE}, returned list
  elements are pointers to objects stored in C (advanced
  use only).}

  \item{...}{Not currently used}
}
\value{
  A list of msa objects, representing the sub-alignments
  for each element in f
}
\description{
  Split an MSA by feature
}
\note{
  Neither x nor f will be altered by this function if they
  are stored as pointers.
}
\examples{
require("rphast")
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
files <- c("ENr334-100k.maf", "gencode.ENr334-100k.gff")
unzip(exampleArchive, files)
m <- read.msa("ENr334-100k.maf")
feats <- read.feat("gencode.ENr334-100k.gff")
feats$seqname <- "hg18"
cdsAlign <- split.by.feature.msa(m, feats[feats$feature=="CDS",])
unlink(files)
}
\author{
  Melissa J. Hubisz and Adam Siepel
}
\keyword{features}
\keyword{msa}

