\name{postprob.msa}
\alias{postprob.msa}
\title{Obtain posterior probilities of every state at every node}
\usage{
  postprob.msa(x, tm, every.site = FALSE)
}
\arguments{
  \item{x}{An object of type \code{msa}}

  \item{tm}{An object of type \code{tm}}

  \item{every.site}{If \code{TRUE}, return probabilities
  for every site rather than every site pattern (this may
  be very redundant and large for a large alignment with
  few species).}
}
\value{
  An array giving the posterior probabilities of all states
  for every unique site pattern, or for every site if
  every.site is \code{TRUE}
}
\description{
  Obtain posterior probilities of every state at every node
}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
unzip(exampleArchive, "ENr334-100k.maf")
m <- read.msa("ENr334-100k.maf")
mod <- phyloFit(m, tree="((hg18,(mm9,rn4)),canFam2)")
x <- postprob.msa(sub.msa(m, start.col=41447839, end.col=41448033, refseq="hg18"), mod)
dim(x)
dimnames(x)
x[,,"CCCC"]

# now get postprobs for every site
x <- postprob.msa(sub.msa(m, start.col=41447839, end.col=41448033, refseq="hg18"), mod, every.site=TRUE)
unlink("ENr334-100k.maf")
}
\author{
  Melissa J. Hubisz and Adam Siepel
}

