\name{optim.rphast}
\alias{optim.rphast}
\title{Optimize using phast's optimization code}
\usage{
  optim.rphast(func, params, lower = NULL, upper = NULL,
    precision = "HIGH", logfile = NULL, ...)
}
\arguments{
  \item{func}{A function to be maximized.  The first
  argument of the function should be a numeric vector of
  the parameters to be optimized}

  \item{params}{A vector of initial values to send as the
  first argument of func.}

  \item{lower}{A vector of the same length as the vector of
  parameters to be optimized, giving the lower bounds for
  each parameter.  If NULL, set the lower bounds to -Inf
  for all parameters.}

  \item{upper}{A vector of the same length as the vector of
  parameters to be optimized, giving the upper bounds for
  each parameter.  If NULL, set the upper bounds to Inf for
  all parameters.}

  \item{precision}{The "precision" to use for the
  optimization, which affects convergence criteria.
  Choices are "LOW", "MED", "HIGH", or "VERY_HIGH".}

  \item{logfile}{If non-NULL, give the name of a file to
  write an optimization log to}

  \item{...}{Additional arguments to be passed to func at
  each function call.  These arguments will not be
  optimized.}
}
\value{
  A list with three elements: value: the optimized value of
  the function, par: a vector giving the parameters at the
  optimized value, and neval: the number of function
  evaluations used in the optimization.
}
\description{
  Optimize an R function using phast's numerical
  optimization procedure
}
\details{
  This function works very much like the optim function in
  the stats package.  In many phast applications, however,
  I have noticed that this function converges just as well
  while taking many fewer function evaluations.  It uses
  the same optimization routine as phyloFit.  In general it
  is most efficient to use phyloFit, because some
  efficiency is lost in passing objects back and forth from
  R to C (as is necessary when using C code to optimize an
  R function, whereas phyloFit uses C code to optimize a C
  function).
}
\author{
  Melissa J. Hubisz and Adam Siepel
}

