% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pdo}
\alias{pdo}
\title{Pacific Decadal Oscillation Index}
\format{A tbl data frame:
\describe{
  \item{Year}{The year as an integer.}
  \item{Month}{The month as an integer.}
  \item{PDO}{The Pacific Decadal Oscillation index as a numeric.}
}}
\usage{
pdo
}
\description{
Monthly Pacific Decadal Oscillation (PDO) index values.
}
\details{
For more information see \url{https://github.com/poissonconsulting/rpdo}.
}
\examples{
library(rpdo)
library(ggplot2)

data(pdo)
ggplot(data = subset(pdo, pdo$Month == 1), aes(x = Year, y = PDO)) +
 geom_line() + ylab("January PDO Index")
}
\keyword{datasets}

