% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis.R
\name{getAnalysisResults}
\alias{getAnalysisResults}
\title{Get Analysis Results}
\usage{
getAnalysisResults(design, dataInput, ...,
  directionUpper = C_DIRECTION_UPPER_DEFAULT, thetaH0 = NA_real_,
  nPlanned = NA_real_)
}
\arguments{
\item{design}{The trial design.}

\item{dataInput}{The summary data used for calculating the test results. 
This is either an element of \code{DatasetMeans}, of \code{DatasetRates}, or of \code{DatasetSurvival}.
For more information see \code{details} below.}

\item{...}{Further arguments to be passed to methods (cp. separate functions in See Also), e.g.,
\describe{
  \item{stage}{The stage number (optional). Default: total number of existing stages in the data input.}
  \item{allocationRatioPlanned}{The allocation ratio n1/n2 for two treatment groups planned for 
      the subsequent stages, the default value is 1.} 
  \item{thetaH1 and assumedStDev or pi1, pi2}{The assumed effect size or assumed rates to calculate the 
      conditional power. Depending on the type of dataset, either thetaH1 (means and survival) 
      or pi1, pi2 (rates) can be specified. Additionally, if testing means is specified, 
      an assumed standard deviation can be specified, default is 1.}
  \item{normalApproximation}{The type of computation of the p-values. Default is FALSE for 
      testing means (i.e., the t test is used) and TRUE for testing rates and the hazard ratio. 
      For testing rates, if \cr
      \code{normalApproximation = FALSE} is specified, the binomial test 
      (one sample) or the test of Fisher (two samples) is used for calculating the p-values.
      In the survival setting, \cr
      \code{normalApproximation = FALSE} has no effect.}  
  \item{equalVariances}{The type of t test. For testing means in two treatment groups, either 
      the t test assuming that the variances are equal or the t test without assuming this, 
      i.e., the test of Welch-Satterthwaite is calculated, default is \code{equalVariances = TRUE}.}
  \item{iterations}{Iterations for simulating the power for Fisher's combination test. 
      If the power for more than one remaining stages is to be determined for 
      Fisher's combination test, it is estimated via simulation with specified \cr 
      \code{iterations}, the default value is 10000.}
  \item{seed}{Seed for simulating the power for Fisher's combination test. 
      See above, default is a random seed.}
}}

\item{directionUpper}{The direction of one-sided testing. 
Default is \code{directionUpper = TRUE} which means that larger values of the 
test statistics yield smaller p-values.}

\item{thetaH0}{The null hypothesis value, default is 0 for the normal and the binary case, 
it is 1 for the survival case.      
For testing a rate in one sample, a value thetaH0 in (0, 1) has to be specified for 
defining the null hypothesis H0: pi = thetaH0.\cr
   For noninferiority designs, this is the noninferiority bound.}

\item{nPlanned}{The sample size planned for the subsequent stages. 
It should be a vector with length equal to the remaining stages and is the 
overall sample size in the two treatment groups if two groups are considered.}
}
\value{
Returns an \code{\link{AnalysisResults}} object.
}
\description{
Calculates and returns the analysis results for the specified design and data.
}
\details{
Given a design and a dataset, at given stage the function calculates the test results 
(effect sizes, stage-wise test statistics and p-values, overall p-values and test statistics, 
conditional rejection probability (CRP), conditional power, Repeated Confidence Intervals (RCIs), 
repeated overall p-values, and final stage p-values, median unbiased effect estimates, 
and final confidence intervals. \cr

\code{dataInput} is either an element of \code{DatasetMeans}, of \code{DatasetRates}, or of 
\code{DatasetSurvival} and should be created with the function \code{\link{getDataset}}.
}
\section{Note}{

The conditional power is calculated only if effect size and sample size 
is specified. Median unbiased effect estimates and confidence intervals are calculated if 
a group sequential design or an inverse normal combination test design was chosen, i.e., it is not applicable 
for Fisher's p-value combination test design. 

A final stage p-value for Fisher's combination test is calculated only if a two-stage design was chosen.
For Fisher's combination test, the conditional power for more than one remaining stages is estimated via simulation.
}

\examples{
design <- getDesignGroupSequential()
dataMeans <- getDataset(
    n = c(10,10),
    means = c(1.96,1.76),
    stDevs = c(1.92,2.01))

getAnalysisResults(design, dataMeans)

# produces:
#
# Analysis results (group sequential design):
#  Stages                        : 1, 2, 3 
#  Information rates             : 0.333, 0.667, 1.000 
#  Critical values               : 3.471, 2.454, 2.004 
#  Futility bounds (non-binding) : -Inf, -Inf 
#  Cumulative alpha spending     : 0.0002592, 0.0071601, 0.0250000 
#  Stage levels                  : 0.0002592, 0.0070554, 0.0225331 
#  Effect sizes                  : 1.96, 1.86, NA 
#  Test statistics               : 3.228, 2.769, NA 
#  p-values                      : 0.005177, 0.010895, NA 
#  Overall test statistics       : 3.228, 4.342, NA 
#  Overall p-values              : 0.0051766, 0.0001757, NA 
#  Futility bounds for power     : NA 
#  Actions                       : continue, reject and stop, NA 
#  Theta H0                      : 0 
#  CRP                           : 0.3177, 0.9434, NA 
#  Planned sample size           : NA, NA, NA 
#  Planned allocation ratio      : 1 
#  Assumed effect                : NA 
#  Assumed standard deviation    : 1 
#  Conditional power             : NA, NA, NA 
#  RCIs (lower)                  : -1.236, 0.702, NA 
#  RCIs (upper)                  : 5.16, 3.02, NA 
#  Repeated p-values             : 0.081766, 0.001825, NA 
#  Final stage                   : 2 
#  Final p-value                 : NA, 0.0004094, NA 
#  Final CIs (lower)             : NA, 0.654, NA 
#  Final CIs (upper)             : NA, 2.36, NA 
#  Median unbiased estimate      : NA, 1.51, NA 

}
\seealso{
Alternatively the analysis results can be calculated separately using one of the following functions:
\itemize{
  \item \code{\link{getTestActions}},
  \item \code{\link{getConditionalPower}},
  \item \code{\link{getConditionalRejectionProbabilities}},
  \item \code{\link{getRepeatedConfidenceIntervals}},
  \item \code{\link{getRepeatedPValues}},
  \item \code{\link{getFinalConfidenceInterval}},
  \item \code{\link{getFinalPValue}}.
}
}
