\name{readChangeLog}
\alias{initChangeLog}
\alias{readChangeLog}
\alias{writeChangeLog}
\title{Read/write ChangeLog files}
\usage{
  readChangeLog(file, head = "ChangeLog for package",
    change = "changes in version", item = "  -")

  writeChangeLog(log, file = NULL,
    head = "ChangeLog for package",
    change = "changes in version", item = "  -",
    lineEnd = 78)

  initChangeLog(entry = list(changed = c("initial release"), fixed = c("missing ChangeLog")),
    package = "unknown", version = "0.01-1",
    date = Sys.Date())
}
\arguments{
  \item{file}{Character string, path to the ChangeLog file
  to read.}

  \item{head}{Character string, the headline text of the
  ChangeLog file (without the package name).}

  \item{change}{Character string, the text introducing each
  ChnageLog entry for a package version.}

  \item{item}{Character string, the text marking each entry
  item.}

  \item{log}{An object of class \code{ChangeLog}.}

  \item{lineEnd}{Integer number, indicates where to do line
  breaks.}

  \item{entry}{A (named) list of character vectors. The
  element names will become the ChangeLog sections, each
  vector element an item.}

  \item{version}{Character string, version number to look
  up.}

  \item{date}{The date of the ChangeLog entry in
  \code{YYYY-MM-DD} format. will be coerced into character.
  To keep the date stamp of a present entry, set
  \code{date=NULL}.}

  \item{package}{Character string, the package name.}
}
\value{
  An object of class \code{ChangeLog}.
}
\description{
  These functions ans methods can be used to manage
  ChangeLog files.
}
\details{
  The ChangeLog files used for R packages are usually
  required to have a standard format, if they are supposed
  to be parsed by functions like \code{tools:::news2Rd}:
  \enumerate{ \item entries are named "Changes in version
  <version number>" (and optionally a YYYY-MM-DD date
  string afterwards) \item they have single changes
  properly itemized, by indentation and then either
  \code{"o"}, \code{"-"} or \code{"*"} followed by space
  \item optionally have categories as subsections, like
  "Fixed", "Changed" or "Added" }

  \code{readChangeLog} tries to read a given ChangeLog file
  and parse its content to generate a special ChangeLog
  object.

  \code{writeChangeLog} takes such a ChangeLog object to
  write it back to a file. If \code{file=NULL}, the log
  will be returned to stdout.

  \code{initChangeLog} generates a ChangeLog object from
  scratch, e.g., to get started with a new package.
}
\examples{
\dontrun{
changelog <- readChangeLog("/home/user/myRsources/myRpackage/ChangeLog")
}
}
\seealso{
  \code{\link[roxyPackage:getChangeLogEntry]{getChangeLogEntry}},
  \code{\link[roxyPackage:updateChangeLog]{updateChangeLog}}
}

