\name{news2rss}
\alias{news2rss}
\title{Generate RSS feeds from R NEWS files}
\usage{
  news2rss(news, rss = NULL, html = NULL,
    encoding = "UTF-8",
    channel = c(title = "", link = "", description = "", language = "", atom = ""))
}
\arguments{
  \item{news}{Character string, path to the R NEWS file to
  be converted.}

  \item{rss}{Character string, path to the RSS.xml file to
  be written. If \code{NULL}, results are written to
  stdout().}

  \item{html}{Logical, whether \code{news} is in HTML or Rd
  format. If \code{NULL}, guess this from the file ending.}

  \item{encoding}{Character string, how the feed is
  encoded.}

  \item{channel}{A named character vector with information
  on this RSS feed: \describe{ \item{\code{title}:}{Title
  of the feed, probably the package name.}
  \item{\code{link}:}{URL to the package web page, e.g. its
  repository site.} \item{\code{description}:}{Descriptions
  of the feed, e.g. the package.}
  \item{\code{language}:}{Optional, a valid RSS language
  code, see
  \code{http://www.rssboard.org/rss-language-codes}.}
  \item{\code{atom}:}{Optional, full URL to the RSS feed on
  the web, used for \code{atom:link rel="self"}.} }}
}
\value{
  No return value, writes a file or to stdout()
}
\description{
  This function should take either HTML or Rd files and
  return a valid RSS 2.0 XML file.
}
\examples{
\dontrun{
channel.info <- c(
  title="roxyPackage",
  link="http://R.reaktanz.de/pckg/roxyPackage",
  description=roxyPackage:::pckg.dscrptn[["Description"]],
  atom="http://R.reaktanz.de/pckg/roxyPackage/rss.xml")
rss.tree <- news2rss("~/R/roxyPackage/NEWS.Rd",
  channel=channel.info)
}
}

