
# This file is automatically generated, you probably don't want to edit this

freqjmvOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "freqjmvOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vector = NULL, ...) {

            super$initialize(
                package='rosetta',
                name='freqjmv',
                requiresData=TRUE,
                ...)

            private$..vector <- jmvcore::OptionVariable$new(
                "vector",
                vector)

            self$.addOption(private$..vector)
        }),
    active = list(
        vector = function() private$..vector$value),
    private = list(
        ..vector = NA)
)

freqjmvResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        table = function() private$.items[["table"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Frequencies")
            self$add(jmvcore::Table$new(
                options=options,
                name="table",
                title="Frequencies",
                rows=4,
                columns=list(
                    list(
                        `name`="value", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="freq", 
                        `title`="Frequencies", 
                        `type`="integer"),
                    list(
                        `name`="percTotal", 
                        `title`="Percentage of total", 
                        `type`="number"),
                    list(
                        `name`="percValid", 
                        `title`="Percentage of valid cases", 
                        `type`="number"),
                    list(
                        `name`="cumulative", 
                        `title`="Cumulative", 
                        `type`="number"))))}))

freqjmvBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "freqjmvBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'rosetta',
                name = 'freqjmv',
                version = c(1,0,0),
                options = options,
                results = freqjmvResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE)
        }))

#' Frequencies
#'
#' 
#' @param data .
#' @param vector .
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$table} \tab \tab \tab \tab \tab a table \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$table$asDF}
#'
#' \code{as.data.frame(results$table)}
#'
#' @export
freqjmv <- function(
    data,
    vector) {

    if ( ! requireNamespace('jmvcore'))
        stop('freqjmv requires jmvcore to be installed (restart may be required)')

    if ( ! missing(vector)) vector <- jmvcore::resolveQuo(jmvcore::enquo(vector))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(vector), vector, NULL))


    options <- freqjmvOptions$new(
        vector = vector)

    analysis <- freqjmvClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
