/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;

public class RORModel {
    protected RealMatrix perfMatrix;
    protected List<PrefPair> prefPairs = new ArrayList<PrefPair>();
    protected RealVector[] levels;

    protected RORModel(RealMatrix perfMatrix) {
        this.perfMatrix = perfMatrix;
        this.initializeLevels(perfMatrix);
    }

    public RealMatrix getPerfMatrix() {
        return this.perfMatrix;
    }

    protected void initializeLevels(RealMatrix perfMatrix) {
        this.levels = new RealVector[perfMatrix.getColumnDimension()];
        int i = 0;
        while (i < this.levels.length) {
            TreeSet<Double> levelsSet = new TreeSet<Double>();
            double[] dArray = perfMatrix.getColumn(i);
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                levelsSet.add(d);
                ++n2;
            }
            ArrayRealVector lvl = new ArrayRealVector(levelsSet.toArray(new Double[0]));
            this.levels[i] = lvl;
            ++i;
        }
    }

    public RealVector[] getLevels() {
        return this.levels;
    }

    public void addPreference(int a, int b) {
        this.prefPairs.add(new PrefPair(a, b));
    }

    public int getNrCriteria() {
        return this.perfMatrix.getColumnDimension();
    }

    public int getNrAlternatives() {
        return this.perfMatrix.getRowDimension();
    }

    protected class PrefPair {
        public int a;
        public int b;

        public PrefPair(int a2, int b2) {
            this.a = a2;
            this.b = b2;
        }
    }
}

