% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%regex<-\%}
\alias{\%regex<-\%}
\title{Assign to vector only where regular expression is matched}
\usage{
x \%regex<-\% value
}
\arguments{
\item{x}{a character vector}

\item{value}{c(pattern, replacement)}
}
\description{
This takes two arguments just like \code{gsub} - a patterns and a replacement.
It will totally overwrite any element where the pattern is matched with the second.
If you want to simply apply a regex (i.e. replace only the specific bit that matches),
use \code{\%regex=\%} instead. If you want to replace with nothing (""), just just \code{\%-\%} or
\code{\%-=\% instead}.
}
\examples{
# Overwrite elements that match regex:

 x <- c("a1b", "b1", "c", "d0")

 # overwrite any element containing a number

 x \%regex<-\% c("\\\\d+", "x")

 print(x)

 # "x" "b" "c" "x"
}
