% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_longwave.R
\name{add_longwave}
\alias{add_longwave}
\title{Add longwave to ensemble forecast dataframe using Idso and Jackson (1969).  Requires cloud cover and temperature variables in input data frame.}
\usage{
add_longwave(df)
}
\arguments{
\item{df}{data frame output from one of the functions that gets a data frame from the API (e.g., \code{get_ensemble_forecast}).  The data frame must has \code{cloud_cover} and \code{temperature_2m} as variables}
}
\value{
data frame with the same columns as the input \code{df} but with \code{longwave_radiation} added as a variable
}
\description{
Add longwave to ensemble forecast dataframe using Idso and Jackson (1969).  Requires cloud cover and temperature variables in input data frame.
}
\examples{

file <- system.file("extdata", "test-data.csv", package="ropenmeteo")
df <- readr::read_csv(file, show_col_types = FALSE)
df  |>
add_longwave()

}
