% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_grid_ahull_crop.R
\name{build_grid_ahull_crop}
\alias{build_grid_ahull_crop}
\title{Regular grid in alpha-hull}
\usage{
build_grid_ahull_crop(coords, npts, pad = NULL, grid_opts = list(alpha =
  0.3))
}
\arguments{
\item{coords}{A matrix or data.frame of coordinates with two columns}

\item{npts}{The number of points before cropping to the alpha hull shape}

\item{pad}{Ignored}

\item{grid_opts}{A list with component \code{alpha} that controls the
shape of the alpha hull}

\item{...}{other arguments are silently ignored}
}
\value{
The coordinates of a grid of points as a \code{data.frame} with
        \code{ncol(coords)} columns. Names are transfered from the
        \code{coords} data frame.
}
\description{
Create a grid within the alpha hull of a set of points.
}
\details{


This function creates a rectangular grid, then computes the alpha
         hull of a set of points, and discards all the points of this grid
         that fall outside of the hull.
}
\seealso{
Other grid.building.functions: \code{\link{build_grid_ahull_fill}};
  \code{\link{build_grid_identical}};
  \code{\link{build_grid_squaretile}}
}

