% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemas.R
\name{fact_schema}
\alias{fact_schema}
\title{\code{fact_schema} S3 class}
\usage{
fact_schema(
  name = NULL,
  measures = NULL,
  agg_functions = NULL,
  nrow_agg = NULL
)
}
\arguments{
\item{name}{A string, name of the fact.}

\item{measures}{A vector of measure names.}

\item{agg_functions}{A vector of aggregation function names, each one for its
corresponding measure. If none is indicated, the default is SUM. Additionally
they can be MAX or MIN.}

\item{nrow_agg}{A string, name of a new measure that represents the COUNT
of rows aggregated for each resulting row.}
}
\value{
A \code{fact_schema} object.
}
\description{
A \code{fact_schema} object is created, the essential data is a name and
a set of measures that can be empty (does not have explicit measures).
It is part of a \code{star_schema} object, defines the facts of the star schema.
}
\details{
Associated with each measure there is an aggregation function that can be
SUM, MAX or MIN. AVG is not considered among the possible aggregation
functions: The reason is that calculating AVG by considering subsets of
data does not necessarily yield the AVG of the total data.

An additional measure corresponding to the COUNT of aggregated rows is added
which, together with SUM, allows us to obtain the AVG if needed.
}
\examples{

f <- fact_schema(
  name = "mrs_cause",
  measures = c(
    "Pneumonia and Influenza Deaths",
    "Other Deaths"
  )
)

f <- fact_schema(
  name = "mrs_cause",
  measures = c(
    "Pneumonia and Influenza Deaths",
    "Other Deaths"
  ),
  agg_functions = c(
    "MAX",
    "SUM"
  ),
  nrow_agg = "Nrow"
)

}
\seealso{
\code{\link{star_database}}

Other star schema definition functions: 
\code{\link{define_dimension}()},
\code{\link{define_facts}()},
\code{\link{dimension_schema}()},
\code{\link{star_schema}()}
}
\concept{star schema definition functions}
